# Date cible
$targetDate = "2022-08-15 00:00:00"

# Convertir la date au format requis par PowerShell
$targetDate = [datetime]::ParseExact($targetDate, "yyyy-MM-dd HH:mm:ss", $null)

# Répertoires à traiter
$directories = @(
    "./ressources/Planet_1/",
    "./ressources/Planet_2/",
    "./ressources/Planet_3/"
)

# Fonction pour changer la date de modification
function Change-ModificationDate($directory, $date) {
    # Trouver tous les fichiers dans le répertoire
    Get-ChildItem -Path $directory -Recurse -File | ForEach-Object {
        # Modifier la date de modification
        $_.LastWriteTime = $date
    }
}

# Appliquer la fonction à chaque répertoire
foreach ($dir in $directories) {
    Change-ModificationDate -directory $dir -date $targetDate
}

Write-Host "Modification des dates terminée."
